package ru.yandex.chemodan.mpfs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.bender.NameUtils;
import ru.yandex.misc.bender.NameWithNamespace;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.reflection.MethodX;

public class RestrictMetaAccessInvocationHandler extends DefaultObject implements InvocationHandler {
    private final MpfsFileMeta delegate;
    private final SetF<String> metaFields;

    private static final MapF<Method, String> methodsMetaName = Cf.concurrentHashMap();
    private static final SetF<Method> methodsToRestrict = ClassX.wrap(MpfsFileMeta.class).getDeclaredMethods()
            .filter(MethodX::isGetter).map(MethodX::getMethod).unique();
    private static final MethodX getMetaJsonFieldMethod =
            ClassX.wrap(MpfsFileMeta.class).getDeclaredMethod("getMetaJsonField", String.class);


    private RestrictMetaAccessInvocationHandler(MpfsFileMeta delegate, SetF<String> metaFields) {
        this.delegate = delegate;
        this.metaFields = metaFields;
    }

    private static String getMetaNameByMethod(Method calledMethod) {
        ClassX<MpfsFileMetaDto> cl = ClassX.wrap(MpfsFileMetaDto.class);
        MethodX method = cl.getMethod(calledMethod.getName(), calledMethod.getParameterTypes());
        Option<BenderPart> benderPartO = method.getAnnotationO(BenderPart.class);
        if (benderPartO.isPresent()) {
            BenderPart benderPart = benderPartO.get();
            NameWithNamespace name = NameUtils.name(benderPart, method::getPropertyName, cl.getPackage());
            return name.getLocalPartJson();
        }

        FieldX field = cl.getDeclaredField(method.getPropertyName());
        benderPartO = field.getAnnotationO(BenderPart.class);
        if (benderPartO.isPresent()) {
            BenderPart benderPart = benderPartO.get();
            NameWithNamespace name = NameUtils.name(benderPart, field::getName, cl.getPackage());
            return name.getLocalPartJson();
        }

        return NameUtils.name(field.getName(), cl.getPackage()).getLocalPartJson();
    }

    public static MpfsFileMeta wrap(MpfsFileMeta delegate, SetF<String> metaFields) {
        if (metaFields == null || metaFields.isEmpty()) {
            //no filtering
            return delegate;
        }

        return (MpfsFileMeta) Proxy.newProxyInstance(
                MpfsFileMetaDto.class.getClassLoader(),
                new Class[]{MpfsFileMeta.class},
                new RestrictMetaAccessInvocationHandler(delegate, metaFields));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (methodsToRestrict.containsTs(method)) {
            String meta = methodsMetaName.getOrElseUpdate(method, () -> getMetaNameByMethod(method));
            if (!metaFields.containsTs(meta)) {
                throw new IllegalStateException(
                        "You are didn't request meta " + meta + " from mpfs, you queried only " + metaFields);
            }
        }
        if (getMetaJsonFieldMethod != null && method.equals(getMetaJsonFieldMethod.getMethod()) && args.length > 0) {
            if (!metaFields.containsTs(Objects.toString(args[0]))) {
                throw new IllegalStateException(
                        "You are didn't request meta " + args[0] + " from mpfs, you queried only " + metaFields);
            }
        }

        return method.invoke(delegate, args);
    }
}

