package ru.yandex.chemodan.mpfs.lentablock;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class MpfsLentaBlockItemDescription extends DefaultObject {

    private static final Logger logger = LoggerFactory.getLogger(MpfsLentaBlockItemDescription.class);

    public final String id;
    public final String fileId;
    public final String resourceId;
    public final Option<Long> ctime;
    public final Option<Long> mtime;
    public final Option<Long> utime;
    public final Option<Long> etime;
    public final String path;
    public final String name;
    public final String type;
    public final Option<String> url;
    public final Option<String> preview;

    public MpfsLentaBlockItemDescription(String id, String fileId, String resourceId, Option<Long> ctime,
            Option<Long> mtime, Option<Long> utime, Option<Long> etime, String path, String name, String type,
            Option<String> url, Option<String> preview)
    {
        this.id = id;
        this.fileId = fileId;
        this.resourceId = resourceId;
        this.ctime = ctime;
        this.mtime = mtime;
        this.utime = utime;
        this.etime = etime;
        this.path = path;
        this.name = name;
        this.url = url;
        this.type = type;
        this.preview = preview;
    }

    public static MpfsLentaBlockItemDescription cons(JsonNode element) {
        return cons(element, null);
    }

    public static MpfsLentaBlockItemDescription cons(JsonNode element, String resourceId) {
        return new MpfsLentaBlockItemDescription(
                element.get("id").textValue(),
                getStringSubPropertyO(element, "meta", "file_id").getOrElse(() -> resourceId),
                getStringSubPropertyO(element, "meta", "resource_id").getOrElse(() -> resourceId),
                getLongPropertyO(element, "ctime"),
                getLongPropertyO(element, "mtime"),
                getLongPropertyO(element, "utime"),
                getLongPropertyO(element, "etime"),
                element.get("path").textValue(),
                element.get("name").textValue(),
                element.get("type").textValue(),
                extractUrl(element),
                getStringSubPropertyO(element,"meta", "preview")
        );
    }

    private static Option<String> extractUrl(JsonNode element) {
        Option<String> fileUrl = getStringSubPropertyO(element, "meta", "file_url");
        Option<String> folderUrl = getStringSubPropertyO(element, "meta", "folder_url");
        return fileUrl.orElse(folderUrl);
    }

    private static Option<Long> getLongPropertyO(JsonNode element, String propertyName) {
        return element.hasNonNull(propertyName)
                ? Cf.Long.parseSafe(element.get(propertyName).asText())
                : Option.empty();
    }

    public static Option<JsonNode> getSubNodeO(JsonNode element, String node, String subNode) {
        Option<JsonNode> jsonNode = getSubNodeO(element, node);
        return jsonNode.filterMap(n -> getSubNodeO(n, subNode));
    }

    private static Option<JsonNode> getSubNodeO(JsonNode element, String node) {
        boolean elementExists = element.hasNonNull(node);
        if (!elementExists) {
            logger.info("Element: {} doesn't Have property: {}", element, node);
            return Option.empty();
        }
        return Option.of(element.get(node));
    }

    private static Option<String> getStringSubPropertyO(JsonNode element, String property, String subProperty) {
        Option<JsonNode> jsonNode = getSubNodeO(element, property, subProperty);
        return jsonNode.filterMap(n -> Option.of(n.textValue()));
    }

}
