package ru.yandex.chemodan.mulca;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaZeroSizeStids;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author akirakozov
 */
@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class MulcaClientContextConfiguration {

    @Bean
    public MulcaClient mulcaClient(
            @Mulca HttpClient client,
            @Value("${mulca.gate.url}") String gateUrl,
            @Value("${mulca.service}") String service,
            @Value("${mulca.namespace}") String namespace,
            @Mulca Optional<List<UnaryOperator<MulcaClient>>> interceptors,
            MulcaZeroSizeStids mulcaZeroSizeStids)
    {
        MulcaClient.Builder builder = MulcaClient
                .custom(client, gateUrl)
                .withMulcaZeroSizeStids(mulcaZeroSizeStids)
                .withService(service)
                .withNamespace(namespace);

        return interceptors.orElseGet(Cf::list).stream().reduce((a, b) -> a.andThen(b)::apply).orElse(UnaryOperator.identity()).apply(builder.build());
    }

    @Bean
    @Mulca
    public HttpClient mulcaHttpClient(@Mulca Optional<List<UnaryOperator<ApacheHttpClientUtils.Builder>>> interceptors) {
        ApacheHttpClientUtils.Builder builder = mulcaHttpClientConfigurator().createBuilder();

        return interceptors.orElseGet(Cf::list).stream().reduce((a, b) -> a.andThen(b)::apply).orElse(UnaryOperator.identity()).apply(builder).build();
    }

    @Bean
    @OverridableValuePrefix("mulca")
    public HttpClientConfigurator mulcaHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Qualifier
    @Retention(RetentionPolicy.RUNTIME)
    public @interface Mulca {
    }

    @Bean
    public MulcaZeroSizeStids mulcaZeroSizeStids(@Value("${mulca.zero.size.stids}") List<String> stids) {
        return new MulcaZeroSizeStids(Cf.toSet(stids));
    }
}
