package ru.yandex.chemodan.mulca;

import java.io.ByteArrayOutputStream;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author vavinov
 */
@ContextConfiguration(classes = MulcaClientContextConfiguration.class)
public class MulcaClientTest extends AbstractTest {
    private static final String TEST_MULCA_IDENTIFIER = "tmp";

    @Autowired
    private MulcaClient mulcaClient;

    @Test
    public void uploadAndDownload() {
        byte[] data = "hello, mulco".getBytes();
        MulcaId id = mulcaClient.upload(InputStreamSourceUtils.bytes(data), TEST_MULCA_IDENTIFIER);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mulcaClient.download(id).readTo(new OutputStreamOutputStreamSource(out));
        Assert.assertArrayEquals(data, out.toByteArray());

        mulcaClient.delete(id);
    }
}
