package ru.yandex.chemodan.mulca;

import com.google.common.primitives.Longs;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author nshmakov
 */
public class MulcaUploadManager {

    @Value("${uploader.director.stage.single.attempt.timeout.fileMulcaUploadInfo.dynamic.for1mb}")
    private Duration uploadTimeoutFor1Mb;
    @Value("${uploader.director.stage.single.attempt.timeout.fileMulcaUploadInfo.dynamic.min}")
    private Duration minUploadTimeout;

    public Duration getTimeoutForUpload(long lengthBytes) {
        long timeoutForLength = uploadTimeoutFor1Mb.getMillis() * DataSize.fromBytes(lengthBytes).toMegaBytes();
        long resultTimeout = Longs.max(minUploadTimeout.getMillis(), timeoutForLength);
        return new Duration(resultTimeout);
    }

    public void setUploadTimeoutFor1Mb(Duration uploadTimeoutFor1Mb) {
        this.uploadTimeoutFor1Mb = uploadTimeoutFor1Mb;
    }

    public void setMinUploadTimeout(Duration minUploadTimeout) {
        this.minUploadTimeout = minUploadTimeout;
    }
}
