package ru.yandex.chemodan.mulca;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author nshmakov
 */
public class MulcaUploadManagerTest {

    private MulcaUploadManager sut = new MulcaUploadManager();

    private Duration timeoutFor1mb = Duration.standardSeconds(1);
    private Duration minTimeout = new Duration(100);

    public MulcaUploadManagerTest() {
        sut.setUploadTimeoutFor1Mb(timeoutFor1mb);
        sut.setMinUploadTimeout(minTimeout);
    }

    @Test
    public void shouldComputeDynamicTimeoutForUpload() {
        Duration actual = sut.getTimeoutForUpload(DataSize.fromMegaBytes(16).toBytes());
        Assert.equals(Duration.standardSeconds(16), actual);
    }

    @Test
    public void shouldReturnMinTimeoutWhenComputedUploadTimeoutIsTooSmall() {
        Duration actual = sut.getTimeoutForUpload(1000);
        Assert.equals(minTimeout, actual);
    }
}
