package ru.yandex.chemodan.orchestrator;

import java.net.URI;

import lombok.AllArgsConstructor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.utils.JacksonResponseHandlerFactory;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadOptionalStringResponseHandler;

/**
 * @link https://wiki.yandex-team.ru/disk/mpfs/meps/mep-067/#apiorkestratora
 * @link ru.yandex.chemodan.app.orchestrator.actions.SessionsActions
 */
@AllArgsConstructor
public class OrchestratorClient {

    private final HttpClient httpClient;
    private final URI baseUrl;
    private final JacksonResponseHandlerFactory handlerFactory;

    public OrchestratorSession createSession(String sessionId, String groupId) {
        HttpPut request = new HttpPut(sessionUriBuilder(sessionId)
                .addParam("group_id", groupId)
                .build());

        return ApacheHttpClientUtils.execute(
                request, httpClient,
                handlerFactory.cons(OrchestratorSession.class));
    }

    public Option<OrchestratorSession> getSession(String sessionId) {

        return ApacheHttpClientUtils.execute(
                new HttpGet(sessionUriBuilder(sessionId).build()),
                httpClient,
                handlerFactory.option(OrchestratorSession.class));
    }

    public boolean refreshSession(String sessionId) {

        Option<String> optional = ApacheHttpClientUtils.execute(
                new HttpPost(sessionUriBuilder(sessionId).build()),
                httpClient,
                new ReadOptionalStringResponseHandler());

        return optional.isPresent();
    }

    public void finishSession(String sessionId) {

        ApacheHttpClientUtils.execute(
                new HttpDelete(sessionUriBuilder(sessionId).build()),
                httpClient,
                new ReadOptionalStringResponseHandler());
    }

    private UriBuilder sessionUriBuilder(String sessionId) {
        return UriBuilder.cons(baseUrl)
                .appendPath("/v1/session/")
                .appendPath(sessionId);
    }
}
