package ru.yandex.chemodan.orchestrator;

import java.net.URI;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.inside.utils.JacksonResponseHandlerFactory;

@Configuration
@Import({
        Tvm2BaseContextConfiguration.class,
        JacksonContextConfiguration.class,
})
public class OrchestratorClientContextConfiguration {

    @Bean
    @Qualifier("orchestrator")
    @OverridableValuePrefix("orchestrator")
    public HttpClientConfigurator orchestratorHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public OrchestratorClient orchestratorClient(
            @Qualifier("orchestrator") HttpClientConfigurator httpClientConfigurator,
            ObjectMapper objectMapper,
            @Value("${orchestrator.base-url}") URI baseUri
    ) {
        return new OrchestratorClient(
                httpClientConfigurator.configure(), baseUri,
                new JacksonResponseHandlerFactory(objectMapper)
        );
    }
}
