package ru.yandex.chemodan.orchestrator;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.misc.ip.HostPort;

@Getter
@NoArgsConstructor
public class OrchestratorSession {
    @JsonProperty("session_id")
    private String sessionId;
    @JsonProperty("container")
    private String container;
    @JsonProperty("group_id")
    private String groupId;
    @JsonProperty("expiration_dt")
    private Instant expirationDt;

    public HostPort getContainer() {
        return HostPort.parse(container);
    }
}
