package ru.yandex.chemodan.ping;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author nshmakov
 */
public class HostsProvider extends DelayingWorkerServiceBeanSupport {

    private static final Logger logger = LoggerFactory.getLogger(HostsProvider.class);

    private final Conductor conductor;
    private volatile String conductorHosts;

    private volatile ListF<String> hosts = Cf.list();

    public HostsProvider(Conductor conductor, String conductorHosts) {
        this.conductor = conductor;
        this.conductorHosts = conductorHosts;
    }

    @Override
    protected void execute() throws Exception {
        hosts = conductor.resolveHostsFromString(conductorHosts);
        logger.info("Resolved: {} for {}", hosts, conductorHosts);
    }

    public ListF<String> getHosts() {
        return hosts;
    }
}
