package ru.yandex.chemodan.ratelimiter;

import org.joda.time.Duration;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RateLimit extends DefaultObject {
    private static final RateLimit PROCEED_WITHOUT_DELAY = proceedWithDelay(Duration.ZERO);

    private static final RateLimit ABORT = new RateLimit(false, Duration.ZERO);

    public final boolean proceed;

    public final Duration delay;

    private RateLimit(boolean proceed, Duration delay) {
        this.proceed = proceed;
        this.delay = delay;
    }

    public static RateLimit proceedWithoutDelay() {
        return PROCEED_WITHOUT_DELAY;
    }

    public static RateLimit proceedWithDelay(Duration delay) {
        return new RateLimit(true, delay);
    }

    public static RateLimit abort() {
        return ABORT;
    }
}
