package ru.yandex.chemodan.ratelimiter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author yashunsky
 */
@Configuration
public class RateLimiterHttpClientContextConfiguration {
    @Bean
    @RateLimiter
    public HttpClient httpClient() {
        return ratelimiterHttpClientConfigurator().configure();
    }

    @Bean
    @OverridableValuePrefix("ratelimiter")
    public HttpClientConfigurator ratelimiterHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Target({ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Qualifier("rateLimiter")
    public @interface RateLimiter {

    }
}
