package ru.yandex.chemodan.ratelimiter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import ru.yandex.misc.ExceptionUtils;

/**
 * @author tolmalev
 */
public class RpsLimitedInvocationHandler<T> implements InvocationHandler {
    private final T target;
    private final ClusteredRpsLimiter rpsLimiter;

    public RpsLimitedInvocationHandler(T target, ClusteredRpsLimiter rpsLimiter) {
        this.target = target;
        this.rpsLimiter = rpsLimiter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        return rpsLimiter.executeWithException(() -> invokeSimple(method, args));
    }

    private Object invokeSimple(Method method, Object[] args) throws Exception {
        try {
            return method.invoke(target, args);
        } catch (IllegalAccessException e) {
            // impossible
            throw ExceptionUtils.translate(e);
        } catch (InvocationTargetException e) {
            throw ExceptionUtils.throwException(e.getTargetException());
        }
    }
}
