package ru.yandex.chemodan.ratelimiter.chunk;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.bolts.function.Function1V;

/**
 * @author yashunsky
 */
public interface ChunkRateLimiter {
    int getDefaultChunkSize();
    <T> T acquirePermitAndExecute(int chunkSize, Function<Integer, T> action);

    default <T> T acquirePermitAndExecute(Function<Integer, T> action) {
        int chunkSize = getDefaultChunkSize();
        return acquirePermitAndExecute(chunkSize, action);
    }

    default void acquirePermitAndExecuteV(Function1V<Integer> action) {
        acquirePermitAndExecute((Function<Integer, ?>) action::applyReturnNull);
    }

    default <T> T acquirePermitAndExecute(int chunkSize, Function0<T> action) {
        return acquirePermitAndExecute(chunkSize, ignoredSize -> action.apply());
    }

    default void acquirePermitAndExecuteV(int chunkSize, Function0V action) {
        acquirePermitAndExecute(chunkSize, (Function0<?>) action::applyReturnNull);
    }
}
