package ru.yandex.chemodan.ratelimiter.chunk;

import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.misc.test.Assert;
import ru.yandex.misc.thread.ThreadUtils;

/**
 * @author yashunsky
 */
public class RequestsBatchBufferTest {
    private RequestsBatchBuffer buffer;

    @Before
    public void before() {
        buffer = new RequestsBatchBuffer(Duration.standardSeconds(1), Duration.millis(100));
    }

    @Test
    public void commonCase() {
        ThreadUtils.sleep(1000);
        buffer.add(1);
        buffer.add(2);
        ThreadUtils.sleep(600);
        buffer.add(3);
        int expected6Requests = buffer.getCount();
        ThreadUtils.sleep(600);
        int expected3Requests = buffer.getCount();
        Assert.equals(6, expected6Requests);
        Assert.equals(3, expected3Requests);
    }
}
