package ru.yandex.chemodan.ratelimiter.chunk.auto;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitor;
import ru.yandex.commune.db.shard2.ShardManager2;

/**
 * @author yashunsky
 */
public abstract class AutoContextAwareRwRateLimiterMapSupport
        extends AutoRwRateLimiterMapSupport implements AutoRwRateLimiter
{
    public AutoContextAwareRwRateLimiterMapSupport(ShardManager2 dataShardManager,
            YasmMonitor yasmMonitor,
            MetricsConfiguration metricsConfiguration,
            RateLimitersMetrics rateLimitersMetrics, Function0<Double> getInitialRateF,
            Function<Integer, Double> getMaxRateF, Function0<Double> getRateIncStepF,
            Function0<Double> getRateDecStepF,
            Function0<Double> getReadRateCoeffF,
            Function0<Double> getWriteRateCoeffF,
            Function0<Double> getMinUsageF,
            Function0<ListF<String>> getIgnoredHostsF,
            Function0<Boolean> getIsAutoEnabledF,
            Function0<Long> getMaxTimeSlotF,
            Function0<Option<Long>> getMaxAwaitTimeF,
            Function0<Integer> getDefaultChunkSizeF, Duration meterInterval,
            Duration averageInterval)
    {
        super(dataShardManager, yasmMonitor, metricsConfiguration, rateLimitersMetrics, getInitialRateF, getMaxRateF,
                getRateIncStepF, getRateDecStepF, getReadRateCoeffF, getWriteRateCoeffF, getMinUsageF, getIgnoredHostsF,
                getIsAutoEnabledF, getMaxTimeSlotF, getMaxAwaitTimeF, getDefaultChunkSizeF, meterInterval,
                averageInterval);
    }

    private AutoRwRateLimiter resolveLimiterFromContext() {
        return getOrElseAddLimiter(resolveKeyFromContext());
    }

    public int getDefaultChunkSize(ReadWrite readWrite) {
        return resolveLimiterFromContext().getDefaultChunkSize(readWrite);
    }

    public <T> T acquirePermitAndExecute(ReadWrite readWrite, int chunkSize, Function<Integer, T> action) {
        return resolveLimiterFromContext().acquirePermitAndExecute(readWrite, chunkSize, action);
    }

    @Override
    public ChunkRateLimiter getReadRateLimiter() {
        return resolveLimiterFromContext().getReadRateLimiter();
    }

    @Override
    public ChunkRateLimiter getWriteRateLimiter() {
        return resolveLimiterFromContext().getWriteRateLimiter();
    }

    @Override
    public boolean hasAwaitingRequests() {
        return resolveLimiterFromContext().hasAwaitingRequests();
    }

    @Override
    public boolean hasAvailableHosts() {
        return resolveLimiterFromContext().hasAvailableHosts();
    }

    abstract protected HostKey resolveKeyFromContext();
}
