package ru.yandex.chemodan.ratelimiter.chunk.auto;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.yasm.monitor.YasmAggrClient;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetricExtractor;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitor;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitorHostsSupplier;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author yashunsky
 */
@ContextConfiguration
public class AutoRateLimiterSupportContextConfiguration {
    @Bean
    public MetricsConfiguration metricsConfiguration(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager,
            @Value("${sharpei-host-identifier}") String sharpeiId,
            @Value("${rate-limiter-support.name}") String name)
    {
        RateLimiterMetricsRegistry registry =
                new RateLimiterMetricsRegistry(zkRoot.child(name + "-metrics-ranges"), sharpeiId);
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    @OverridableValuePrefix("yasmMonitor")
    public HttpClientConfigurator yasmMonitorHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public YasmMonitor yasmMonitor(
            ShardManager2 dataShardManager,
            @Qualifier("yasmMonitorHttpClientConfigurator") HttpClientConfigurator httpClientConfigurator,
            @Value("${host-status-maintenance-period}") Duration maintenancePeriod,
            @Value("${host-status-averaging-interval}") Duration averageInterval)
    {
        YasmMonitorHostsSupplier hostsSupplier = new ShardsHostsSupplier(dataShardManager);
        YasmAggrClient client = new YasmAggrClient(httpClientConfigurator.configure());
        return new YasmMonitor(hostsSupplier, client, YasmMetricExtractor.ALL, maintenancePeriod, averageInterval);
    }

    @Bean
    public RateLimitersMetrics rateLimitersMetrics(@Value("${rate-limiter-support.name}") String name) {
        return new RateLimitersMetrics(name);
    }

}
