package ru.yandex.chemodan.ratelimiter.chunk.auto;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author yashunsky
 */
public interface AutoRwRateLimiter extends Maintained {
    boolean hasAvailableHosts();
    boolean hasAwaitingRequests();

    ChunkRateLimiter getReadRateLimiter();
    ChunkRateLimiter getWriteRateLimiter();

    default ChunkRateLimiter getLimiter(ReadWrite readWrite) {
        switch (readWrite) {
            case READ: return getReadRateLimiter();
            case WRITE: return getWriteRateLimiter();
            default: throw new IllegalStateException();
        }
    }

    default <T> T acquirePermitAndExecute(ReadWrite readWrite, int chunkSize, Function<Integer, T> action) {
        return getLimiter(readWrite).acquirePermitAndExecute(chunkSize, action);
    }

    default int getDefaultChunkSize(ReadWrite readWrite) {
        return getLimiter(readWrite).getDefaultChunkSize();
    }
}
