package ru.yandex.chemodan.ratelimiter.chunk.auto;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * @author yashunsky
 */
public abstract class AutoRwRateLimiterMap<K, L extends AutoRwRateLimiter> implements Maintained {
    private final MapF<K, L> limiters;

    public AutoRwRateLimiterMap() {
        this.limiters = Cf.concurrentHashMap();
    }

    public L getOrElseAddLimiter(K key) {
        return limiters.getOrElseUpdate(key, () -> {
            L limiter = limiterConstructor(key);
            limiter.maintain();
            return limiter;
        });
    }

    public boolean hasAvailableHosts(K key) {
        return getOrElseAddLimiter(key).hasAvailableHosts();
    }

    public boolean hasAwaitingRequests(K key) {
        return getOrElseAddLimiter(key).hasAwaitingRequests();
    }

    public boolean removeIfEmpty(K key) {
        return !limiters.getO(key).exists(L::hasAwaitingRequests) && remove(key);
    }

    public boolean remove(K key) {
        return limiters.removeTs(key) != null;
    }

    abstract protected L limiterConstructor(K key);

    @Override
    public void maintain() {
        limiters.values().forEach(AutoRwRateLimiter::maintain);
    }

    @Override
    public void updateMetrics() {
        limiters.values().forEach(AutoRwRateLimiter::updateMetrics);
    }
}
