package ru.yandex.chemodan.ratelimiter.chunk.auto;

import javax.sql.DataSource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.db.shard2.Shard2;
import ru.yandex.misc.db.DataSourceUtils;
import ru.yandex.misc.db.masterSlave.DataSourceStatusSource;
import ru.yandex.misc.db.masterSlave.DataSourceWithStatus;
import ru.yandex.misc.db.url.JdbcUrl;

/**
 * @author yashunsky
 */
public class DataSourceHostsUtils {
    public static ListF<DataSourceWithStatus> getDataSources(Shard2 shard, String name) {
        DataSource dataSource = shard.getDataSource();
        if (!(dataSource instanceof DataSourceStatusSource)) {
            return Cf.list();
        }

        return ((DataSourceStatusSource) dataSource)
                .getDataSourcesWithStatuses(name);
    }

    public static Option<String> getHost(DataSourceWithStatus dsws) {
        return Option.x(DataSourceUtils.url(dsws.getDs())).filterMap(url -> JdbcUrl.valueOf(url).getHost());
    }

    public static Option<HostMasterSlave> getHostMasterSlave(DataSourceWithStatus dsws) {
        Option<String> hostO = getHost(dsws);
        MasterSlave masterSlave = dsws.isMaster().orElse(false) ? MasterSlave.MASTER : MasterSlave.SLAVE;
        return hostO.map(host -> new HostMasterSlave(host, masterSlave));
    }

    public static Option<HostMasterSlave> getHostMasterSlave(DataSourceWithStatus dsws, ListF<String> ignoredHosts) {
        Option<HostMasterSlave> hostMasterSlave = getHostMasterSlave(dsws);

        if (hostMasterSlave.exists(hms -> ignoredHosts.containsTs(hms.getHost()))) {
            return Option.empty();
        }

        return hostMasterSlave;
    }
}
