package ru.yandex.chemodan.ratelimiter.chunk.auto;

import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;

/**
 * @author yashunsky
 */
public enum MasterSlave {
    MASTER,
    SLAVE;

    public boolean isMaster() {
        return this == MASTER;
    }

    public boolean isSlave() {
        return this == SLAVE;
    }

    public static MasterSlave fromPolicy(MasterSlavePolicy policy) {
        switch (policy) {
            case RW_M:
            case R_M:
            case R_MS:
                return MASTER;
            case R_SM:
            case R_ANY:
            case R_S:
                return SLAVE;
            default:
                throw new IllegalStateException("unsupported MS policy " + policy);
        }
    }
}
