package ru.yandex.chemodan.ratelimiter.chunk.auto;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetric;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Getter
@BenderBindAllFields
public class RateLimiterMetricKey {
    private final String sharpeiId;
    private final YasmMetric metric;
    private final Option<MasterSlave> masterSlave;
    private final Option<String> host;

    @Override
    public String toString() {
        return Cf.list(sharpeiId, metric.toString())
                .plus(masterSlave.map(Object::toString)).plus(host).mkString("-");
    }

    private <A> int suites(A expected, Option<A> key) {
        if (key.isSome(expected)) {
            return 1;
        } else if (key.isPresent()) {
            return -1;
        } else {
            return 0;
        }
    }

    public int suites(String sharpeiId, String host, MasterSlave masterSlave) {
        if (!this.sharpeiId.equals(sharpeiId)) {
            return -1;
        }

        int hostPoints = suites(host, this.host) * 2;
        int msPoints = suites(masterSlave, this.masterSlave);

        if (hostPoints < 0 || msPoints < 0) {
            return -1;
        } else {
            return Math.max(hostPoints, msPoints);
        }
    }
}
