package ru.yandex.chemodan.ratelimiter.chunk.auto;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetric;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetricRanges;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Getter
@BenderBindAllFields
public class RateLimiterMetricRanges {
    private final RateLimiterMetricKey key;
    private final YasmMetricRanges value;

    private int getMatchLevel(String sharpeiId, String host, MasterSlave masterSlave) {
        return key.suites(sharpeiId, host, masterSlave);
    }

    private YasmMetric getMetric() {
        return key.getMetric();
    }

    public static MapF<YasmMetric, YasmMetricRanges> groupMatching(
            CollectionF<RateLimiterMetricRanges> ranges, String sharpeiId, String host, MasterSlave masterSlave)
    {
        return ranges.map(r -> new RangesWithMatchLevel(r, r.getMatchLevel(sharpeiId, host, masterSlave)))
                .filter(RangesWithMatchLevel::matches)
                .groupBy(RangesWithMatchLevel::getMetric)
                .mapValues(r -> r.max(RangesWithMatchLevel.getComparator()).getValue());
    }

    @AllArgsConstructor
    @Getter
    private static class RangesWithMatchLevel {
        private final RateLimiterMetricRanges ranges;
        private final int matchLevel;

        public boolean matches() {
            return matchLevel >= 0;
        }

        public YasmMetric getMetric() {
            return ranges.getMetric();
        }

        public YasmMetricRanges getValue() {
            return ranges.getValue();
        }

        public static Comparator<RangesWithMatchLevel> getComparator() {
            return Comparator.naturalComparatorBy(RangesWithMatchLevel::getMatchLevel);
        }
    }
}
