package ru.yandex.chemodan.ratelimiter.chunk.auto;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetric;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetricRanges;
import ru.yandex.misc.test.Assert;

/**
 * @author yashunsky
 */
public class RateLimiterMetricRangesTest {
    @Test
    public void choseOverride() {

        String sharpeiId = "test";
        String anotherSharpeiId = "notSoTest";

        String host1 = "host1";
        String host2 = "host2";

        ListF<YasmMetricRanges> yasmRanges = Cf.list(
                new YasmMetricRanges(1, 2),
                new YasmMetricRanges(2, 3),
                new YasmMetricRanges(3, 4),
                new YasmMetricRanges(4, 5)
        );

        ListF<RateLimiterMetricKey> keys = Cf.list(
                new RateLimiterMetricKey(sharpeiId, YasmMetric.IO, Option.empty(), Option.empty()),
                new RateLimiterMetricKey(sharpeiId, YasmMetric.IO, Option.of(MasterSlave.MASTER), Option.empty()),
                new RateLimiterMetricKey(sharpeiId, YasmMetric.IO, Option.empty(), Option.of(host1)),
                new RateLimiterMetricKey(anotherSharpeiId, YasmMetric.LA, Option.empty(), Option.empty()));

        ListF<RateLimiterMetricRanges> allRanges = keys.zip(yasmRanges).map(RateLimiterMetricRanges::new);

        MapF<YasmMetric, YasmMetricRanges> host1Ranges =
                RateLimiterMetricRanges.groupMatching(allRanges, sharpeiId, host1, MasterSlave.MASTER);
        Assert.equals(host1Ranges.keys(), Cf.list(YasmMetric.IO));
        Assert.equals(yasmRanges.get(2), host1Ranges.getTs(YasmMetric.IO));

        MapF<YasmMetric, YasmMetricRanges> host2IfMasterRanges =
                RateLimiterMetricRanges.groupMatching(allRanges, sharpeiId, host2, MasterSlave.MASTER);
        Assert.equals(host2IfMasterRanges.keys(), Cf.list(YasmMetric.IO));
        Assert.equals(yasmRanges.get(1), host2IfMasterRanges.getTs(YasmMetric.IO));

        MapF<YasmMetric, YasmMetricRanges> host2IfSlaveRanges =
                RateLimiterMetricRanges.groupMatching(allRanges, sharpeiId, host2, MasterSlave.SLAVE);
        Assert.equals(host2IfSlaveRanges.keys(), Cf.list(YasmMetric.IO));
        Assert.equals(yasmRanges.get(0), host2IfSlaveRanges.getTs(YasmMetric.IO));
    }
}
