package ru.yandex.chemodan.ratelimiter.chunk.auto;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetric;
import ru.yandex.chemodan.util.yasm.monitor.YasmMetricRanges;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author yashunsky
 */
public class RateLimiterMetricsRegistry
        extends ZkRegistry<RateLimiterMetricKey, RateLimiterMetricRanges>
        implements MetricsConfiguration
{
    private final String sharpeiId;

    public RateLimiterMetricsRegistry(ZkPath path, String sharpeiId) {
        super(
                path,
                new BenderMapper().createParserSerializer(RateLimiterMetricRanges.class),
                RateLimiterMetricRanges::getKey,
                RateLimiterMetricKey::toString
        );

        this.sharpeiId = sharpeiId;
    }

    @Override
    public MapF<YasmMetric, YasmMetricRanges> getRanges(String host, MasterSlave masterSlave) {
        return RateLimiterMetricRanges.groupMatching(getAll(), sharpeiId, host, masterSlave);
    }

    public void putGlobal(YasmMetric metric, double warn, double crit) {
        put(metric, Option.empty(), Option.empty(), warn, crit);
    }

    public void put(YasmMetric metric, Option<MasterSlave> masterSlave, Option<String> host, double warn, double crit) {
        RateLimiterMetricKey key = new RateLimiterMetricKey(sharpeiId, metric, masterSlave, host);
        put(new RateLimiterMetricRanges(key, new YasmMetricRanges(warn, crit)));
    }
}
