package ru.yandex.chemodan.ratelimiter.chunk.auto;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author yashunsky
 */

@AllArgsConstructor
public class RateLimiterReference implements ChunkRateLimiter {
    private final AutoRwRateLimiter innerLimiter;
    private final ReadWrite readWrite;

    @Override
    public int getDefaultChunkSize() {
        return innerLimiter.getDefaultChunkSize(readWrite);
    }

    @Override
    public <T> T acquirePermitAndExecute(int chunkSize, Function<Integer, T> action) {
        return innerLimiter.acquirePermitAndExecute(readWrite, chunkSize, action);
    }
}
