package ru.yandex.chemodan.ratelimiter.chunk.auto;

import lombok.AllArgsConstructor;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.ValueMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class RateLimitersMetrics implements MonicaContainer {
    private final String name;

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(name, new MetricName(name), name + " inner metrics");
    }

    @MonicaMetric(description = "Rates")
    @GroupByDefault
    public final ValueMap<Double> rates = new ValueMap<>(Double.class);

    @MonicaMetric(description = "Shards health")
    @GroupByDefault
    public final ValueMap<Integer> shardsHealth = new ValueMap<>(Integer.class);
}
