package ru.yandex.chemodan.ratelimiter.chunk.auto;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitorHostsSupplier;
import ru.yandex.commune.db.shard2.ShardManager2;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class ShardsHostsSupplier implements YasmMonitorHostsSupplier {
    private final ShardManager2 dataShardManager;

    @Override
    public ListF<String> getHosts() {
        return dataShardManager.shards()
                .flatMap(shard -> DataSourceHostsUtils.getDataSources(shard, "ds"))
                .filterMap(DataSourceHostsUtils::getHost);
    }
}
