package ru.yandex.chemodan.ratelimiter.yarl;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author friendlyevil
 */
public class YarlHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(YarlHttpClient.class);

    private final HttpClient httpClient;
    private final String baseUrl;

    public YarlHttpClient(HttpClient httpClient, String baseUrl) {
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    public RateLimiterStatus checkLimit(String clientId, int weight) {
        URI uri = UriBuilder.cons(baseUrl)
                .appendPath(clientId)
                .addParam("weight", weight)
                .build();

        try {
            HttpResponse response = httpClient.execute(new HttpGet(uri));
// https://stackoverflow.com/questions/16019612/org-apache-http-conn-connectionpooltimeoutexception-timeout-waiting-for-connect
            EntityUtils.consumeQuietly(response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.SC_429_TOO_MANY_REQUESTS) {
                return RateLimiterStatus.REJECTED;
            }
        } catch (IOException e) {
            logger.warn(e);
        }

//      в любой непонятной ситуации запрос пропускаем
        return RateLimiterStatus.ACCEPTED;
    }
}
