package ru.yandex.chemodan.ratelimiter.yarl;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author friendlyevil
 */
@Configuration
public class YarlRateLimiterHttpClientContextConfiguration {
    @Bean
    @Qualifier("yarl")
    public HttpClient httpClient() {
        return ratelimiterHttpClientConfigurator().configure();
    }

    @Bean
    public YarlHttpClient yarlHttpClient(@Qualifier("yarl") HttpClient httpClient,
                                         @Value("${yarl.base.url}")String baseUrl) {
        return new YarlHttpClient(httpClient, baseUrl);
    }

    @Bean
    @OverridableValuePrefix("yarl")
    public HttpClientConfigurator ratelimiterHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
