package ru.yandex.chemodan.ratelimiter.yarl;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
public abstract class YarlWithClientFilterInterceptor extends YarlBaseInterceptor {
    private final Supplier<Boolean> isEnabled;
    private final Supplier<Boolean> isWhiteListMode;
    private final Supplier<ListF<String>> enabledForClients;
    private final Supplier<ListF<String>> disabledForClients;

    public YarlWithClientFilterInterceptor(YarlHttpClient yarlHttpClient,
                                           Supplier<Boolean> isDryRun,
                                           Supplier<Boolean> isEnabled,
                                           Supplier<Boolean> isWhiteListMode,
                                           Supplier<ListF<String>> enabledForClients,
                                           Supplier<ListF<String>> disabledForClients) {
        super(yarlHttpClient, isDryRun);
        this.isEnabled = isEnabled;
        this.isWhiteListMode = isWhiteListMode;
        this.enabledForClients = enabledForClients;
        this.disabledForClients = disabledForClients;
    }

    @Override
    protected boolean needRateLimitCheck(HttpServletRequestX request) {
        return isEnabled.get() && super.needRateLimitCheck(request)
                && getClientId(request).map(this::enabledForClient).orElse(true);
    }

    private boolean enabledForClient(String clientId) {
        if (isWhiteListMode.get()) {
            return enabledForClients.get().containsTs(clientId);
        } else {
            return !disabledForClients.get().containsTs(clientId);
        }
    }
}
