package ru.yandex.chemodan.scripter;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.scripter.admin.ScripterAdminContextConfiguration;
import ru.yandex.commune.util.serialize.ToMultilineSerializer;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        ScripterAdminContextConfiguration.class
})
public class ScripterContextConfiguration {
    @Bean
    public ScripterManager scripterManager(ScripterScriptsRegistry scripterScriptsRegistry, ToMultilineSerializer toMultilineSerializer) {
        return new ScripterManager(scripterScriptsRegistry, toMultilineSerializer);
    }

    @Bean
    public ScripterScriptsRegistry scripterScriptsRegistry(ZkManager zkManager, @Qualifier("zkRoot") ZkPath zkRoot) {
        ScripterScriptsRegistry registry = new ScripterScriptsRegistry(zkRoot.child("scripter").child("scripts"));
        zkManager.addClient(registry);
        return registry;
    }
}
