package ru.yandex.chemodan.scripter;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.script.cosher.InterpreterPopulator;
import ru.yandex.commune.script.cosher.InterpreterUtils;
import ru.yandex.commune.script.cosher.RichInterpreter;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreter;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreterDefaultPopulator;
import ru.yandex.commune.util.serialize.ToMultilineSerializer;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author tolmalev
 */
public class ScripterManager {
    private final ScripterScriptsRegistry registry;
    private final ToMultilineSerializer toMultilineSerializer;

    public ScripterManager(ScripterScriptsRegistry registry, ToMultilineSerializer toMultilineSerializer) {
        this.registry = registry;
        this.toMultilineSerializer = toMultilineSerializer;
    }

    public ListF<ScripterScript> getAll() {
        return registry.getAll().sortedBy(ScripterScript::getId);
    }

    public ScripterScript get(String scriptId) {
        return registry.get(scriptId);
    }

    public Option<ScripterScript> getO(String scriptId) {
        return registry.getO(scriptId);
    }

    public void remove(String scriptId) {
        registry.remove(scriptId);
    }

    public void save(ScripterScript script) {
        registry.put(script);
    }

    public ScriptInvocationResult invoke(String id, MapF<String, String> parameters) {
        ScripterScript script = registry.get(id);

        StringWriter sw = new StringWriter();
        RichInterpreter interpreter = createInterpreter(new PrintWriter(sw, true));

        try {
            parameters.forEach(interpreter::bindVariable);
            Object result = interpreter.eval(script.jsCode);

            return new ScriptInvocationResult(
                    parameters,
                    true,
                    sw.toString(),
                    Option.ofNullable(result).map(toMultilineSerializer.serializeF())
            );
        } catch (Throwable e) {
            ExceptionUtils.throwIfUnrecoverable(e);

            return new ScriptInvocationResult(
                    parameters,
                    false,
                    ExceptionUtils.getStackTrace(e),
                    Option.empty()
            );
        }
    }

    // XXX: copy paste from ru.yandex.commune.admin.web.script.ScriptContextConfiguration
    @Autowired
    private ApplicationContext applicationContext;
    private InterpreterPopulator interpreterPopulator = new NashornInterpreterDefaultPopulator();

    public RichInterpreter createInterpreter(PrintWriter out) {
        RichInterpreter interpreter = new NashornInterpreter(out);
        InterpreterUtils.loadContext(interpreter, applicationContext);
        interpreterPopulator.populate(interpreter);
        return interpreter;
    }
}
