package ru.yandex.chemodan.scripter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@Data
@AllArgsConstructor
@Builder(toBuilder = true)
@BenderBindAllFields
public class ScripterScript {
    public final String id;
    public final String description;
    public final ListF<Parameter> parameters;
    public final String jsCode;

    public final ListF<String> invokers;

    public ScripterScript(String id) {
        this(id, "", Cf.list(), "print('Hello World!')", Cf.list());
    }

    @Data
    @BenderBindAllFields
    public static class Parameter {
        public final String name;
        public final String description;
    }
}
