<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <xsl:apply-templates select="scripts"/>
    </xsl:template>

    <xsl:template match="scripts">
        <xsl:variable name="id" select="id"/>

        <h1>
            Скрипт "<xsl:value-of select="id"/>"
        </h1>
        <b>Описание:</b>
        <xsl:text> </xsl:text>
        <xsl:value-of select="description"/>

        <br/>
        <br/>

        <xsl:if test="not(can-invoke = 'true')">
            Нет прав на выполнение этого скрипта
        </xsl:if>

        <xsl:if test="can-invoke = 'true'">
            <form method="POST" action="/z/scripter/invoke" width="100%">
                <input type="hidden" name="id" value="{id}"/>

                <xsl:if test="count(parameters) = 0">
                    <button type="submit" class="btn-small btn-success">Выполнить без параметров</button>
                </xsl:if>

                <xsl:if test="count(parameters) > 0">
                    <dl>
                        <xsl:for-each select="parameters">
                            <dt>
                                <xsl:value-of select="name"/>
                            </dt>
                            <dd>
                                <div class="form-group">
                                    <input name="{name}" type="text" class="form-control" placeholder="{description}"/>
                                </div>
                            </dd>
                        </xsl:for-each>
                        <dt/>
                        <dd>
                            <button type="submit" class="btn btn-success">Выполнить</button>
                        </dd>
                    </dl>
                </xsl:if>
            </form>
        </xsl:if>

        <br/>
        <hr/>

        <xsl:if test="can-edit = 'true'">
            <h1>
                Редактирование
            </h1>
        </xsl:if>

        <xsl:if test="not(can-edit = 'true')">
            <h1>
                Просмотр кода
            </h1>
        </xsl:if>

        <div class="modal fade" id="addParameterModal" tabindex="-1" role="dialog" aria-labelledby="addParameterModal" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3>Добавить параметр</h3>
                    </div>
                    <div class="modal-body">
                        <form action="/z/scripter/add_parameter" method="POST">
                            <input class="form-control" name="id" type="hidden" value="{id}"/>

                            <div class="form-group row">
                                <label for="url" class="col-sm-2 col-form-label">name</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="name" type="text"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="title" class="col-sm-2 col-form-label">description</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="description" type="text"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Добавить параметр</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <xsl:for-each select="parameters">
            <div class="modal fade" id="removeParameterModal{name}" tabindex="-1" role="dialog" aria-labelledby="removeParameterModal{name}" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3>Удалить параметр <xsl:value-of select="name"/> </h3>
                        </div>
                        <div class="modal-body">
                            <form action="/z/scripter/remove_parameter" method="POST">
                                <input class="form-control" name="id" type="hidden" value="{$id}"/>
                                <input class="form-control" name="name" type="hidden" value="{name}"/>

                                <button class="btn btn-danger">Удалить параметр <xsl:value-of select="name"/></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </xsl:for-each>

        <form method="POST" action="/z/scripter/save_code">
            <input type="hidden" name="id" value="{id}"/>

            <h3>
                Описание
            </h3>
            <input type="text" name="description" value="{description}" class="form-control">
                <xsl:if test="not(can-edit = 'true')">
                    <xsl:attribute name="disabled">true</xsl:attribute>
                </xsl:if>
            </input>

            <h3>
                Параметры
            </h3>
            <xsl:if test="count(parameters) = 0">
                <h5>
                    <small>Нет параметров</small>
                </h5>
            </xsl:if>

            <xsl:for-each select="parameters">
                <xsl:if test="can-edit = 'true'">
                    <button type="button" class="btn btn-link" data-toggle="modal" data-target="#removeParameterModal{name}">☓</button>
                    <xsl:text> </xsl:text>
                </xsl:if>
                <b><xsl:value-of select="name"/> </b>:
                <xsl:value-of select="description"/>
                <br/>
            </xsl:for-each>

            <xsl:if test="can-edit = 'true'">
                <h5>
                    <small>
                        <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addParameterModal">Добавить</button>
                    </small>
                </h5>
            </xsl:if>


            <h3>
                Код скрипта
            </h3>
            <textarea rows="20" class="form-control" name="jsCode">
                <xsl:if test="not(can-edit = 'true')">
                    <xsl:attribute name="disabled">true</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="js-code"/>
            </textarea>

            <xsl:if test="can-edit = 'true'">
                <br/>
                <button type="submit" class="btn btn-success">Сохранить</button>
            </xsl:if>
        </form>
        <br/>

        <xsl:if test="can-edit = 'true'">
            <div class="modal fade" id="deleteScriptModal" tabindex="-1" role="dialog" aria-labelledby="deleteScriptModal" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3>Удалить скрипт?</h3>
                        </div>
                        <div class="modal-body">
                            <form action="/z/scripter/delete" method="POST">
                                <input class="form-control" name="id" type="hidden" value="{$id}"/>

                                <button class="btn btn-danger">Удалить</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn btn-danger" data-toggle="modal" data-target="#deleteScriptModal">Удалить скрипт</button>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>
