<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <h1>
            Список скриптов
        </h1>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <th width="1%">id</th>
                <th>Описание</th>
            </tr>
            <xsl:for-each select="scripts">
                <tr>
                    <td>
                        <xsl:if test="can-invoke = 'true'">
                            <a href="/z/scripter/edit?id={id}">
                                <xsl:value-of select="id"/>
                            </a>
                        </xsl:if>

                        <xsl:if test="not(can-invoke = 'true')">
                            <xsl:value-of select="id"/>
                        </xsl:if>
                    </td>
                    <td>
                        <xsl:value-of select="description"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>

        <xsl:if test="can-create = 'true'">
            <form method="POST" action="/z/scripter/save_code" class="edit-form">
                <dl class="dl-horizontal">
                    <dt>
                        <button type="submit" class="btn btn-success">Создать</button>
                    </dt>
                    <dd>
                        <div class="form-group">
                            <input name="id" type="text" class="form-control" placeholder="unique_script_id"/>
                        </div>
                        <div class="form-group">
                            <input name="description" type="text" class="form-control" placeholder="описание"/>
                        </div>
                        <input type="hidden" name="jsCode" value=""/>
                    </dd>
                </dl>
            </form>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>
