<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>


    <xsl:variable name="invocation" select="/page/content/invocation"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <xsl:apply-templates select="script"/>
        <xsl:apply-templates select="invocation"/>
    </xsl:template>

    <xsl:template match="script">
        <h1>
            Скрипт "<xsl:value-of select="id"/>"
            <xsl:if test="can-edit = 'true'">
                <a href="/z/scripter/edit?id={id}">edit</a>
            </xsl:if>
        </h1>
        <b>Описание:</b>
        <xsl:text> </xsl:text>
        <xsl:value-of select="description"/>

        <br/>
        <br/>

        <xsl:if test="can-invoke = 'true'">
            <form method="POST" action="/z/scripter/invoke" class="edit-form" width="100%">
                <input type="hidden" name="id" value="{id}"/>

                <xsl:if test="count(parameters) = 0">
                    <button type="submit" class="btn-small btn-success">Выполнить без параметров</button>
                </xsl:if>

                <xsl:if test="count(parameters) > 0">
                    <dl class="dl-horizontal">
                        <xsl:for-each select="parameters">
                            <dt>
                                <xsl:value-of select="name"/>
                            </dt>
                            <dd>
                                <xsl:variable name="fname" select="name"/>
                                <div class="form-group">
                                    <input name="{name}" type="text" class="form-control" placeholder="{description}"
                                    value="{$invocation/parameters[key=$fname]/value}"/>
                                </div>
                            </dd>
                        </xsl:for-each>
                        <dt>
                            <button type="submit" class="btn btn-success">Выполнить</button>
                        </dt>
                        <dd/>
                    </dl>
                </xsl:if>
            </form>
        </xsl:if>
    </xsl:template>

    <xsl:template match="invocation">
        <h1>
            Результаты запуска
        </h1>
        <b>Вывод скрипта</b>
        <pre>
            <xsl:value-of select="output"/>
        </pre>

        <b>Результат</b>
        <pre>
            <xsl:value-of select="s-result"/>
        </pre>
    </xsl:template>

</xsl:stylesheet>
