package ru.yandex.chemodan.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;

public class ColumnTableTupleRowMapper implements RowMapper<List<Tuple2<String, Object>>> {

    @Override
    public List<Tuple2<String, Object>> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();

        Map<String, Map<Integer, String>> columnTableName = new HashMap<>();
        for (int i = 1; i <= columnCount; i++) {
            String columnKey = getColumnKey(JdbcUtils.lookupColumnName(rsmd, i));
            columnTableName
                    .computeIfAbsent(columnKey, (Function<String, Map<Integer, String>>) s -> new HashMap<>())
                    .put(i, rsmd.getTableName(i));
        }

        List<Tuple2<String, Object>> columnValueList = new LinkedList<>();
        for (int i = 1; i <= columnCount; i++) {
            String key = getColumnKey(JdbcUtils.lookupColumnName(rsmd, i));
            Map<Integer, String> tableName = columnTableName.get(key);
            if (tableName.size() > 1) {
                key = tableName.get(i) + "." + key;
            }
            Object obj = getColumnValue(rs, i);
            columnValueList.add(new Tuple2<>(key, obj));
        }
        return columnValueList;
    }


    protected String getColumnKey(String columnName) {
        return columnName;
    }


    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

}

