package ru.yandex.chemodan.sql;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminGroups;
import ru.yandex.commune.db.admin.sql.SqlAdminManager;

/**
 * @author vvkleba
 */
@Configuration
public class SqlBetaAdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @Autowired
    private SqlAdminManager sqlAdminManager;

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(AdminGroups.DB, new SqlWithHighlightAdminPage(sqlAdminManager), true);
    }
}
