<?xml version="1.0"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="xsl z"
    xmlns:z="urn:zscript-functions"
    version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" href="/z/r/sql/style.css"/>

        <link rel='stylesheet' href='/z/r/sql_beta/lib/codemirror.min.css'/>
        <link rel='stylesheet' href='/z/r/sql_beta/lib/show-hint.min.css'/>
        <link rel='stylesheet' href='/z/r/sql_beta/lib/dracula.min.css'/>
        <link rel='stylesheet' href='/z/r/sql_beta/lib/all.min.css'/>

        <script src='/z/r/sql_beta/lib/codemirror.min.js'/>
        <script src='/z/r/sql_beta/lib/sql.min.js'/>
        <script src='/z/r/sql_beta/lib/sql-hint.min.js'/>
        <script src='/z/r/sql_beta/lib/show-hint.min.js'/>
        <script src='/z/r/sql_beta/lib/active-line.min.js'/>

        <style>
        <![CDATA[
            :root {
            --bgc-a: #eef2f4;
            --hover-el-color: #fff;
            --hover-el-bg: #7cc3c6
            }

            .CodeMirror-hints {
            background-color: var(--bgc-a) !important;
            border: 0;
            padding: 2px 3px;
            border-radius: 0;
            max-width: 800px !important;
            overflow-x: auto !important
            }

            .CodeMirror-hint {
            background-color: var(--bgc-a) !important;
            color: var(--color-a) !important;
            padding: 2px 7px;
            border-radius: 0
            }

            .CodeMirror-hint-active {
            background-color: var(--hover-el-bg) !important;
            color: var(--hover-el-color) !important
            }
        ]]>
        </style>

    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <script type="text/javascript">

            <![CDATA[const spaceSize = 2;]]>
            <xsl:variable name="nodes" select="//node()/metadata"/>


            <xsl:variable name="max_column_size">
                <xsl:for-each select="$nodes/value/tables/table/value/columns/column/name">
                    <xsl:sort select="string-length(.)" data-type="number" />
                    <xsl:if test="position() = last()">
                        <xsl:value-of select="string-length(.)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>

            <xsl:variable name="max_table_size">
                <xsl:for-each select="$nodes/value/tables/table">
                    <xsl:sort select="string-length(key)" data-type="number" />
                    <xsl:if test="position() = last()">
                        <xsl:value-of select="string-length(key)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>


            <![CDATA[const columnData = ]]>
            {
            <xsl:for-each select="$nodes">
                '<xsl:value-of select="./key"/>' : [
                <xsl:for-each select="./value/tables/table">
                    <xsl:for-each select="value/columns/column">
                        {
                        'icon': 'fa fa-columns',
                        'text': '<xsl:value-of select="./name"/>',
                        'displayText': '<xsl:value-of select="./name"/>' + '\u00A0'.repeat(<xsl:value-of select="$max_column_size"/> + <xsl:value-of select="$max_table_size"/> + spaceSize - <xsl:value-of select="string-length(./name)"/> - <xsl:value-of select="string-length(../../../key)"/>) + '<xsl:value-of select="../../../key"/>',
                        'columns': []

                        }<xsl:if test="position() != last()">,</xsl:if>
                    </xsl:for-each>
                    <xsl:if test="position() != last()">,</xsl:if>
                </xsl:for-each>
                ]<xsl:if test="position() != last()">,</xsl:if>
            </xsl:for-each>
            } ;

            <![CDATA[const tableData =]]>
            <xsl:variable name="nodes" select="//node()/metadata"/>
            {
            <xsl:for-each select="$nodes">
                '<xsl:value-of select="./key"/>' : [

                <xsl:for-each select="./value/tables/table">
                    {
                    'icon': 'fa fa-table',
                    'text': '<xsl:value-of select="./key"/>',
                    'displayText': '<xsl:value-of select="./key"/>' + '\u00A0'.repeat(<xsl:value-of select="$max_column_size"/> + <xsl:value-of select="$max_table_size"/> + spaceSize - <xsl:value-of select="string-length(./key)"/> - 5) + 'TABLE',
                    'columns': [
                    <xsl:for-each select="value/columns/column">
                        {
                        'icon': 'fa fa-columns',
                        'text': '<xsl:value-of select="./name"/>',
                        'displayText': '<xsl:value-of select="./name"/>' + '\u00A0'.repeat(<xsl:value-of select="$max_column_size"/> + <xsl:value-of select="$max_table_size"/> + spaceSize - <xsl:value-of select="string-length(./name)"/> - <xsl:value-of select="string-length(../../../key)"/>) + '[<xsl:value-of select="../../../key"/>]'
                        }<xsl:if test="position() != last()">,</xsl:if>
                    </xsl:for-each>
                    ]
                    }<xsl:if test="position() != last()">,</xsl:if>
                </xsl:for-each>
                ]<xsl:if test="position() != last()">,</xsl:if>
            </xsl:for-each>
            }  ;
        </script>

        <ul class="nav nav-tabs">
            <xsl:variable name="is-execute"
                          select="z:iif-url-starts-with('/z/sql_beta/execute', true(), false()) = true()"/>
            <li class="{z:iif2($is-execute, '', 'active')}">
                <a href="/z/sql_beta">Find All</a>
            </li>
            <li class="{z:iif2($is-execute, 'active', '')}">
                <a href="/z/sql_beta/execute">Execute</a>
            </li>
        </ul>
        <div class="form">
            <form method="POST" id="sql-form" onSubmit="formData.set('query', codemirror.getValue());">
                <textarea name="query" class="submit" style="height: 4em;" type="hidden">
                    <xsl:value-of select="/page/req/query/param[@name='query']"/>
                </textarea>
                <div class="form-inline" style="margin-top: 10px">
                    <select class="col-md-3" id="ds" name="ds" onchange="">
                        <xsl:for-each select="data-sources/data-source">
                            <option value="{.}">
                                <xsl:if
                                    test="/page/req/query/param[@name='ds'] = . or (/page/req/query/param[@name='ds'] = '' and position() = 1)">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                <xsl:value-of select="."/>
                            </option>
                        </xsl:for-each>
                    </select>
                    <button type="submit" class="btn btn-primary">Run</button>
                </div>
            </form>

            <script type="text/javascript">

            <![CDATA[
                const codemirror = CodeMirror.fromTextArea(document.querySelector('.submit'), {
                    mode: 'text/x-pgsql',
                    lineNumbers: true,
                    styleActiveLine: true,
                    autofocus: true,
                    theme: 'dracula',
                    extraKeys: {
                        'Ctrl-Enter': function (cm) {
                            document.getElementById('sql-form').submit();
                        }}
                });

                codemirror.on('inputRead', function (instance) {
                    if (instance.state.completionActive) {
                        return;
                    }
                    var cur = instance.getCursor();
                    var token = instance.getTokenAt(cur);
                    var string = '';
                    if (token.string.match(/^[.`\w@]\w*$/)) {
                        string = token.string;
                    }
                    if (string.length > 0) {
                        CodeMirror.commands.autocomplete(instance);
                    }
                });

                function updateHintDictionary(value) {
                    CodeMirror.commands.autocomplete = function (cmeditor) {
                        CodeMirror.showHint(cmeditor, CodeMirror.hint.sql, {
                            completeSingle: false,
                            tables: tableData[value],
                            column: columnData[value]
                        });
                    };
                }


                function copyToClipboard() {
                    var text = '#|';
                    var table = document.getElementById('results-table');

                    for (var i = 0; i < table.rows.length; i++) {
                        text += '||';
                        var row = table.rows[i];
                        for (var j = 0; j < row.cells.length; j++) {
                            text += row.cells[j].innerText.replace(/\\/g, "\\\\").replaceAll('|', String.raw`\|`);
                            text += (j === row.cells.length - 1) ? '' : ' | ';
                        }
                        text += '||';
                    }
                    text += '|#';

                    navigator.clipboard
                        .writeText(text)
                        .then(() => {
                            var el = $('#main-content > div > div > button');
                            var elOriginalText = el.attr('data-original-title');
                            el.attr('data-original-title', 'Copied!').tooltip('show');

                            el.attr('data-original-title', elOriginalText)
                        })
                        .catch((e) => {
                            alert(e)
                        });
                }

                const select = document.getElementById('ds');
                select.onchange = function () {
                    updateHintDictionary(this.value);
                };
                updateHintDictionary(select.value);

                $('#main-content > div > div > button').tooltip();
                ]]>
        </script>
            <script src='/z/r/sql_beta/lib/hint-font.js'/>


            <xsl:if test="query">
                <xsl:choose>
                    <xsl:when test="error">
                        <div id="error" class="alert alert-danger" style="display: block; ">
                            <strong>Problem!</strong>
                            <span class="message">
                                <xsl:value-of select="error"/>
                            </span>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="rows"/>
                        <xsl:apply-templates select="rows-affected"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="rows-affected">
        <div class="alert alert-success">
            Query <strong>OK</strong>,
            <xsl:value-of select="."/> rows affected.
        </div>
    </xsl:template>

    <xsl:template match="rows">
        <div class="alert alert-success">
            Query <strong>OK</strong>, returned
            <xsl:value-of select="count(row)"/> rows.
            <button onclick="copyToClipboard()" type="button" class="close" aria-label="Copy" style="opacity: 1;"
                    data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Copy to clipboard">
                <i class="fa fa-clipboard" aria-hidden="true"></i>
            </button>
        </div>
        <table class="table table-condensed" id="results-table">
            <thead>
                <xsl:for-each select="row[1]">
                    <tr class="headers">
                        <xsl:for-each select="items">
                            <th>
                                <xsl:value-of select="column"/>
                            </th>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </thead>
            <tbody class="results">
                <xsl:for-each select="row">
                    <tr>
                        <xsl:for-each select="items">
                            <td>
                                <xsl:value-of select="value"/>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>

</xsl:stylesheet>
