package ru.yandex.chemodan.tvm2;

import java.util.concurrent.TimeUnit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

import ru.yandex.bolts.collection.Unit;

public class CachingUserTicketSupplier implements UserTicketSupplier {

    private final LoadingCache<Unit, String> cache;

    public CachingUserTicketSupplier(UserTicketSupplier base) {
        cache = CacheBuilder.newBuilder()
                .expireAfterWrite(5, TimeUnit.MINUTES)
                .build(CacheLoader.from(base::getUserTicket));
    }

    @Override
    public String getUserTicket() {
        return cache.getUnchecked(Unit.U);
    }
}
