package ru.yandex.chemodan.tvm2;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.BlackboxType;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.net.LocalhostUtils;

public class OAuthUserTicketSupplier implements UserTicketSupplier {

    private final String oauthToken;
    private final Blackbox2 blackbox;
    private final Supplier<Option<String>> serviceTicketSupplier;

    public OAuthUserTicketSupplier(String oauthToken, BlackboxType type, Tvm2 tvm2) {
        this.oauthToken = oauthToken;
        this.blackbox = Blackbox2.cons(type);
        this.serviceTicketSupplier = () -> tvm2.getServiceTicket(type.getTvmDstClientId());
    }

    @Override
    public String getUserTicket() {
        String serviceTicket = serviceTicketSupplier.get()
                .orElseThrow(() -> new IllegalStateException("Missing service ticket"));

        BlackboxCorrectResponse response = blackbox.query().oAuth(
                LocalhostUtils.localAddress(), oauthToken,
                Cf.list(), Cf.list(),
                Option.empty(), Option.empty(),
                true, serviceTicket
        );
        return response.getTvmUserTicket()
                .orElseThrow(() -> new IllegalStateException("Missing user ticket"));
    }
}
