package ru.yandex.chemodan.util;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.version.AppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AppNameHolder {
    private static volatile Option<AppName> value = Option.empty();

    public static AppName get() {
        return value.getOrThrow("Not initialized yet");
    }

    public synchronized static void set(AppName appName) {
        if (isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }

        value = Option.of(appName);
    }

    // for tests only
    public static void setIfNotPresent(AppName appName) {
        if (isInitialized()) {
            return;
        }

        set(appName);
    }

    public static boolean isInitialized() {
        return value.isPresent();
    }
}
