package ru.yandex.chemodan.util;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.exception.IncorrectAppVersionFormatException;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;

@Bendable
public class AppVersion implements Comparable<AppVersion> {

    private static final String VERSION_DELIMITER = "\\.";

    private static String mapZero(String value) {
        return Cf.Integer.parse(value) == 0 ? "00" : value;
    }

    private final ListF<String> versionParts;

    public AppVersion(String version) {
        try {
            this.versionParts = Cf.x(version.split(VERSION_DELIMITER)).map(AppVersion::mapZero);
        } catch (NumberFormatException e) {
            throw new IncorrectAppVersionFormatException(version);
        }
    }

    @Override
    public int compareTo(AppVersion other) {
        int sizeLimit = Math.min(this.versionParts.size(), other.versionParts.size());
        for (int i = 0; i < sizeLimit; i++) {
            String myVersionPart = this.versionParts.get(i);
            String otherVersionPart = other.versionParts.get(i);
            int compareResult = compareVersionParts(myVersionPart, otherVersionPart);
            if (compareResult == 0) {
                continue;
            }
            return compareResult;
        }
        return Integer.compare(this.versionParts.size(), other.versionParts.size());
    }

    private int compareVersionParts(String myVersionPart, String otherVersionPart) {
        if (myVersionPart.startsWith("0") || otherVersionPart.startsWith("0")) {
            return myVersionPart.compareTo(otherVersionPart);
        }
        return Cf.Integer.parse(myVersionPart).compareTo(Cf.Integer.parse(otherVersionPart));
    }

    public String asXivaParameterString() {
        return versionParts.mkString("");
    }

    @Override
    public String toString() {
        return asBenderString();
    }

    @BenderTextValue
    public static AppVersion fromBenderString(String benderString) {
        return new AppVersion(benderString);
    }

    @BenderTextValue
    public String asBenderString() {
        return versionParts.mkString(".");
    }
}
