package ru.yandex.chemodan.util;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class AppVersionTest {

    @Test
    public void testCompare() {
        assertTrue(new AppVersion("3.0").compareTo(new AppVersion("2.99")) > 0);
        assertTrue(new AppVersion("3.0").compareTo(new AppVersion("3.00")) == 0);
        assertTrue(new AppVersion("3.12.1").compareTo(new AppVersion("3.12.1.1")) < 0);
        assertTrue(new AppVersion("2.35").compareTo(new AppVersion("2.34")) > 0);
        assertTrue(new AppVersion("2.12.36").compareTo(new AppVersion("2.12.37")) < 0);
        assertTrue(new AppVersion("2.13.40").compareTo(new AppVersion("2.12.53")) > 0);
        assertTrue(new AppVersion("10.01").compareTo(new AppVersion("9.02")) > 0);
        assertTrue(new AppVersion("3.07").compareTo(new AppVersion("3.7")) < 0);
    }

    @Test
    public void testXivaString() {
        assertEquals("256", new AppVersion("2.56").asXivaParameterString());
        assertEquals("10000", new AppVersion("100.0").asXivaParameterString());
        assertEquals("300", new AppVersion("3.0").asXivaParameterString());
    }
}
