package ru.yandex.chemodan.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

public class BatchCollectorTest {

    @Test
    public void test() {
        List<Integer> result = Cf.arrayList();
        BatchCollector<Integer> objectBatchCollector = new BatchCollector<>(10, objects -> result.addAll(objects));

        IntStream.range(1, 103).boxed().collect(objectBatchCollector);
        Assert.assertListsEqual(IntStream.range(1, 103).boxed().collect(Collectors.toList()), result);

    }
}
