package ru.yandex.chemodan.util;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyContainer;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.env.EnvironmentType;

/**
 * @author dbrylev
 * @author akirakozov
 * @author swined
 */
public class BleedingEdge implements DynamicPropertyContainer {
    private final DynamicProperty<Boolean> enabled;
    private final DynamicProperty<ListF<Long>> uids;
    private final DynamicProperty<Double> percent;
    private final DynamicProperty<ListF<Long>> denyUids;

    public BleedingEdge(String prefixName) {
        enabled = new DynamicProperty<>(prefixName + "-bleeding-edge-enabled",
                Cf.list(EnvironmentType.PRESTABLE, EnvironmentType.PRODUCTION).containsTs(EnvironmentType.getActive()));
        uids = new DynamicProperty<>(prefixName + "-bleeding-edge-uids", Cf.list());

        percent = new DynamicProperty<>(prefixName + "-bleeding-edge-percent", 0.0);

        //move to another class after removing BleedingEdge
        denyUids = new DynamicProperty<>(prefixName + "-deny-uids", Cf.list());
    }

    public boolean isOnBleedingEdge(PassportUid uid) {
        return !denyUids.get().containsTs(uid.getUid()) &&
                (!enabled.get()
                    || uids.get().containsTs(uid.getUid())
                    || uid.getUid() % 100000 < Math.round(percent.get() * 1000)
        );
    }
}
