package ru.yandex.chemodan.util;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

import ru.yandex.chemodan.util.DigestChecker.MpfsFileId;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.chemodan.util.test.TestUser;

/**
 * @author akirakozov
 */
public class DigestCheckerTest extends AbstractTest {
    @Value("${mulca.gate.url}")
    private String mulcaUrl;
    @Value("${mpfs.host}")
    private String mpfsHost;

    @Test
    public void checkDigestByHid() {
        DigestChecker checker = new DigestChecker(mulcaUrl, mpfsHost);
        Assert.isTrue(checker.checkFileDigestsUnsafe(new MpfsFileId(TestUser.TEST_HID)));
    }

    @Test
    public void checkDigestByUidAndPath() {
        DigestChecker checker = new DigestChecker(mulcaUrl, mpfsHost);
        Assert.isTrue(checker.checkFileDigestsUnsafe(new MpfsFileId(TestUser.uid, "/disk/hello.txt")));
    }

}
