package ru.yandex.chemodan.util;

import java.io.IOException;
import java.io.Writer;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.search.AbstractSearchInfoGrabber;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class DownloadFromMulcaGrabber extends AbstractSearchInfoGrabber {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFromMulcaGrabber.class);

    private final File2 outDir;
    private final int filesToDownload;
    private final String searchParams;
    private final MulcaClient mulcaClient;
    private int downloaded;

    public DownloadFromMulcaGrabber(
            File2 outDir, int filesToDownload,
            String searchParams, MulcaClient mulcaClient)
    {
        super("dump.txt");
        this.outDir = outDir;
        this.filesToDownload = filesToDownload;
        this.searchParams = searchParams;
        this.mulcaClient = mulcaClient;
        this.downloaded = 0;
    }

    @Override
    protected void grabInfoForUid(PassportUid uid, Writer out) throws IOException {
        SearchResult result = searchClient.getSearchInfo(uid, searchParams);
        result.items.stream().filter(item -> item.stid.isPresent()).forEach(item -> {
            String fileName = getFileName(item.filename);
            try {
                File2 outFile = outDir.child(fileName);
                logger.debug("Store file to " + outFile.getAbsoluteFile());
                mulcaClient.download(MulcaId.fromSerializedString(item.stid.get())).readTo(outFile);
                downloaded++;
            } catch (Exception e) {
                logger.debug("Couldn't download file from mulca", e);
            }
        });
    }

    @Override
    protected boolean stopProcessing() {
        return downloaded > filesToDownload;
    }


    private String getFileName(Option<String> srcFilename) {
        String name = StringUtils.leftPad(Integer.toString(downloaded), 8, '0');
        if (srcFilename.isPresent()) {
            String ext = new File2(srcFilename.get()).getExtension();
            name = StringUtils.isBlank(ext) ? name : name + "." + ext;
        }
        return name;
    }

}
