package ru.yandex.chemodan.util;


import java.util.function.Supplier;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.Stopwatch;

/**
 * @author akirakozov
 */
public class ExecUtils2 {
    private static final Logger logger = LoggerFactory.getLogger(ExecUtils2.class);

    public static ExecResult executeGrabbingOutputWithLogging(ListF<String> cmd) {
        ExecResult result = executeWithLogging(cmd, () -> ExecUtils.executeGrabbingOutput(cmd));
        logger.info("Execution result code={}, output: [\n{}\n]", result.getCode(), result.getOutput());
        return result;
    }

    public static void executeWithLogging(ListF<String> cmd) {
        executeWithLogging(cmd, () -> {
            ExecUtils.executeCommand(cmd);
            return null;
        });
    }

    private static <T> T executeWithLogging(ListF<String> cmd, Supplier<T> func) {
        logger.info("Executing: command={}", cmd);
        Stopwatch stopwatch = Stopwatch.createAndStart();
        T result = func.get();
        stopwatch.stopAndLog("Execution", logger);

        return result;
    }
}
